<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../helpers.php';
requireLogin();
if ($_SESSION['user']['role'] === 'admin') header('Location: /admin/index.php');
$recent = $pdo->prepare('SELECT * FROM activity_logs WHERE user_id = ? ORDER BY created_at DESC LIMIT 5');
$recent->execute([$_SESSION['user']['id']]);
$logs = $recent->fetchAll();
require_once __DIR__ . '/../includes/header.php';
?>
<div class="row">
  <div class="col-md-8">
    <h3>Welcome, <?=htmlspecialchars($_SESSION['user']['name'])?></h3>
    <p class="text-muted">Quick actions</p>
    <div class="d-flex gap-2">
      <a href="/employee/add_log.php" class="btn btn-success">Add Activity</a>
      <a href="/employee/my_logs.php" class="btn btn-outline-secondary">My Logs</a>
    </div>
  </div>
  <div class="col-md-4">
    <div class="card">
      <div class="card-body">
        <h5>Recent activities</h5>
        <?php if($logs): ?><ul class="list-group list-group-flush"><?php foreach($logs as $l): ?><li class="list-group-item"><strong><?=htmlspecialchars($l['title'])?></strong><br><small class="text-muted"><?=htmlspecialchars($l['status'])?> · <?=htmlspecialchars($l['start_time'])?></small></li><?php endforeach; ?></ul><?php else: ?><p class="text-muted">No recent activities.</p><?php endif; ?>
      </div>
    </div>
  </div>
</div>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
