<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../helpers.php';
requireLogin();
// handle delete
if ($_SERVER['REQUEST_METHOD']==='POST' && !empty($_POST['delete_id'])) {
    $id=(int)$_POST['delete_id'];
    $stmt=$pdo->prepare('DELETE FROM activity_logs WHERE id=? AND user_id=?');
    $stmt->execute([$id,$_SESSION['user']['id']]);
    header('Location: /employee/my_logs.php');
    exit;
}
$stmt=$pdo->prepare('SELECT * FROM activity_logs WHERE user_id=? ORDER BY start_time DESC');
$stmt->execute([$_SESSION['user']['id']]);
$logs=$stmt->fetchAll();
require_once __DIR__ . '/../includes/header.php';
?>
<h4>My Logs</h4>
<table class="table">
  <thead><tr><th>Title</th><th>Start</th><th>End</th><th>Status</th><th>Action</th></tr></thead>
  <tbody>
    <?php foreach($logs as $l): ?>
    <tr>
      <td><?=htmlspecialchars($l['title'])?></td>
      <td><?=htmlspecialchars($l['start_time'])?></td>
      <td><?=htmlspecialchars($l['end_time'])?></td>
      <td><?=htmlspecialchars($l['status'])?></td>
      <td>
        <form method="post" style="display:inline" onsubmit="return confirm('Delete log?');">
          <input type="hidden" name="delete_id" value="<?=$l['id']?>">
          <button class="btn btn-sm btn-danger">Delete</button>
        </form>
      </td>
    </tr>
    <?php endforeach; ?>
  </tbody>
</table>
<?php require_once __DIR__ . '/../includes/footer.php'; ?>
