<?php
// helpers.php
function isLoggedIn() {
    return isset($_SESSION['user']);
}
function isAdmin() {
    return isLoggedIn() && $_SESSION['user']['role'] === 'admin';
}
function requireLogin() {
    if (!isLoggedIn()) {
        header('Location: /auth/login.php');
        exit;
    }
}
function requireAdmin() {
    if (!isAdmin()) {
        header('Location: /auth/login.php');
        exit;
    }
}
function exportCSV($rows, $filename = 'export.csv') {
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename='.$filename);
    $out = fopen('php://output', 'w');
    if (count($rows) > 0) {
        fputcsv($out, array_keys($rows[0]));
        foreach ($rows as $row) fputcsv($out, $row);
    }
    fclose($out);
    exit;
}
?>